%% #############################################################################
% $TI Release: TIDA_010054_DAB_Converter_Dual_Phase_Shift_Control_Ver1.0
% $Release Date: Sep 28 2022
% $Copyright:
% Copyright (C) 2022 Texas Instruments Incorporated - http://www.ti.com/
% $Description: This file initializes all the necessary parameters for the
% Simulation. This must be executed befre starting the simulation model.
% $
% ALL RIGHTS RESERVED
% $
%  #############################################################################


%% Dual phase shift control scheme with voltage loop                                  
% Transfromer characteristics from manufacturer

Ae = 0.000516;              % cross-sectional area[m^2]
B_sat = 0.6;                % flux density sat [T];
Le = 0.112;                 % lengh of flux path [m]
ur_init = 2400;             % unsat rel. permeability 
ur_sat = 4;                 %sat rel. permeability 

n_pri = 24;                 % Primary windings
n_sec = 15;                 % Secondary windings
Rpri = 43e-3;               % Primary DC resitance
Rsec = 16e-3;               % Secondary DC resitance

% Leakage inductor characteristics from manufacturer
Llk = 35E-6;                % Inductance
R_Llk = 23e-3;              % DC Resistance

% DC Blocking Capacitors
C_block = (14*0.47e-6);     % Capacitance


%FET Primary C3M0075120K
rgoff_pri = 3;              % turn off gate resistence 
rgon_pri = 5;               % turn on gate resistence
ron_body_diode_pri = 0.04;  % body diode on resitance
ron_mosfet_pri = 0.075;     % 75mohm
vf_body_diode_pri = 4.5;    % Body diode foreward voltage
rth_ch_pri =0.1;              % thermal res case-heatsink

%FET Secondary C3M0030090K
rgoff_sec = 3;              % turn off gate resistence
rgon_sec = 5;               % turn on gate resistence
ron_body_diode_sec = 0.02;  % body diode on resitance
ron_mosfet_sec = 0.03;      %30mohm
vf_body_diode_sec = 4.5;    %Body diode foreward voltage
rth_ch_sec =0.1;            % thermal res case-heatsink
%
Vin = 800;                  %Input voltage
V_Ref = 500;                % Output voltage reference (only used for coltage lop)
Pout = 10000;	
I_Ref = 20;						 % Output curent reference (only used for current loop)
%Output Capacitor
Co = 60E-6;                %Capacitance
Co_esr = 0.0016;            %ESR
Cout_init = 0;              % Initial voltage

%Controller Single phase shift
duty_cycle = 0.5;           % Duty cycle is always 50% in this implementation
f = 100e3;                  % switching freqeuncy
tdead = 100e-9;             % dead time 100ns


%Sampling time for controler
Ts = 100e-6;                %100us
V_MAX = 827;  					  % Maximum voltage sense on primary for conversion to pu (same as in TIDA_010054 code)
I_MAX = 41.7;					% Maximum current sense on primary for conversion to pu (same as in TIDA_010054 code)


% Load
RLoad = 25;

%Themal models of Switches
device_sec = 'file:C3M0030090K';        %900V 30mohm
device_pri = 'file:C3M0075120K';        %1200V 75mohm
t_init=25;                              %initial temperature
t_amb = 25;										 %Ambinat temperature
Rth = 0.7;										 %thermal resitance of heatsinks
EPS_EN =1;



t_sim = 1;

